IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[dbo].[SF_CB_PagoFacil]') 
                   and [type] = 'FN')
BEGIN
	/*Ya no se utiliza mas*/
    DROP FUNCTION dbo.SF_CB_PagoFacil
END
GO

IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[dbo].[SF_PagoFacil_CB_TX]') 
                   and [type] = 'FN')
BEGIN
	/*Ya no se utiliza mas*/
    DROP FUNCTION dbo.SF_PagoFacil_CB_TX
END
GO

IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[dbo].[CF_PagoFacil_CB_TX]') 
                   and [type] = 'FN')
BEGIN
    DROP FUNCTION dbo.CF_PagoFacil_CB_TX
END
GO

CREATE FUNCTION [dbo].[CF_PagoFacil_CB_TX](@pId_Trans INT) 
RETURNS CHAR(55)
AS
BEGIN

DECLARE @Retorno	CHAR(55)

DECLARE @EmpresaServicio	CHAR(4)
DECLARE @ImportePriVenc		CHAR(8)
DECLARE @Fecha_Venc			DATETIME
DECLARE @FechaPriVenc		CHAR(5)
DECLARE @Id_Cliente			INT
DECLARE @IdentCliente		CHAR(14)
DECLARE @Moneda				CHAR(1)
DECLARE @RecargoSegVenc		CHAR(6)
DECLARE @FechaSegVenc		CHAR(2)
DECLARE @DatosSinDigVer		CHAR(40)
DECLARE @DatosConDigVerifA	CHAR(41)
DECLARE @SecuenciaA			CHAR(5)
DECLARE @SecuenciaB			CHAR(4)
DECLARE @SecuenciaC			CHAR(3)
DECLARE @MultiplicadorA		CHAR(40)
DECLARE @MultiplicadorB		CHAR(41)
DECLARE @pos				SMALLINT
DECLARE @Suma				DECIMAL(12,2)
DECLARE @DigVerificadorA	CHAR(1)
DECLARE @DigVerificadorB	CHAR(1)
DECLARE @DigVerificador		CHAR(2)

/*===========================================================================================*/

SET @EmpresaServicio	= (SELECT SUBSTRING(Valor_String,5,4) FROM xParametros WHERE IdParametro='Id_PagoFacil_Uti')

SET @ImportePriVenc		= (SELECT RIGHT('00000000' + CAST(cast((ISNULL(Imp_Total,0) + ISNULL(Saldo_Anterior,0)) * Cotizacion * 100 AS INT) AS VARCHAR), 8) FROM Cbtes WHERE Id_Trans = @pId_Trans)

SET @Fecha_Venc			= (SELECT Fecha_Venc FROM Cbtes WHERE Id_Trans = @pId_Trans)

SET @FechaPriVenc		=	(SUBSTRING(CAST(DATEPART(YY,@Fecha_Venc) AS CHAR(4)),3,2) + 
							SUBSTRING(CAST(DATEPART(dy,@Fecha_Venc) + 1000 AS CHAR(4)),2,3))

SET @Id_Cliente			= ISNULL((SELECT ISNULL(Id_Cliente, 0) FROM Cbtes WHERE Id_Trans = @pId_Trans),0)
SET @IdentCliente		= (SELECT RIGHT('00000000000000' + CAST(@Id_Cliente AS VARCHAR),14))
		
SET @Moneda				= '0'
SET @RecargoSegVenc		= '000000'
SET @FechaSegVenc		= '00'

/*===========================================================================================*/

SET @DatosSinDigVer =	@EmpresaServicio +
						@ImportePriVenc +
						@FechaPriVenc +
						@IdentCliente +
						@Moneda +
						@RecargoSegVenc +
						@FechaSegVenc

SET @SecuenciaA = '13579'
SET @SecuenciaB = '3579'
SET @SecuenciaC = '357'
SET @MultiplicadorA = @SecuenciaA + @SecuenciaB + @SecuenciaB + @SecuenciaB + @SecuenciaB + @SecuenciaB + @SecuenciaB + @SecuenciaB + @SecuenciaB + @SecuenciaC

SET @pos = 1
SET @Suma = 0
   
WHILE (@pos < 41)
BEGIN
	SET @Suma = @Suma + CAST(SUBSTRING(@DatosSinDigVer,@pos,1) AS INT) * CAST(SUBSTRING(@MultiplicadorA,@pos,1) AS INT)
    SET @pos = @pos + 1
END
   
SET @Suma = @Suma / 2
   
SET @DigVerificadorA = CAST(CAST(@Suma AS INT) % 10 AS CHAR(1))

SET @DatosConDigVerifA = @DatosSinDigVer + @DigVerificadorA

/*===========================================================================================*/

SET @MultiplicadorB = @SecuenciaA + @SecuenciaB + @SecuenciaB + @SecuenciaB + @SecuenciaB + @SecuenciaB + @SecuenciaB + @SecuenciaB + @SecuenciaB + @SecuenciaB

SET @pos = 1
SET @Suma = 0
   
WHILE (@pos < 42)
BEGIN
	SET @Suma = @Suma + CAST(SUBSTRING(@DatosConDigVerifA,@pos,1) AS INT) * CAST(SUBSTRING(@MultiplicadorB,@pos,1) AS INT)
    SET @pos = @pos + 1
END
   
SET @Suma = @Suma / 2
   
SET @DigVerificadorB = CAST(CAST(@Suma AS INT) % 10 AS CHAR(1))

/*===========================================================================================*/
SET @DigVerificador = @DatosConDigVerifA + @DigVerificadorB
/*===========================================================================================*/

SET @Retorno =	@EmpresaServicio + /*04 caracteres. Empresa de Servicio.*/
				@ImportePriVenc +  /*08 caracteres. Formato: 6 enteros 2 decimales.*/
				@FechaPriVenc +    /*05 caracteres. Formato: AADDD. Ej. 05/07/2003 = 03186*/
				@IdentCliente +	   /*14 caracteres. Identificacion del Cliente.*/
				@Moneda	+		   /*01 caracteres. Valor "0" (Pesos).*/
				@RecargoSegVenc	+  /*06 caracteres. Formato: 4 enteros 2 decimales.*/
				@FechaSegVenc +	   /*02 caracteres. Formato DD.*/
				@DigVerificador	   /*02 caracteres. Doble Verificacion.*/
				
RETURN ISNULL(@Retorno, '                                                       ')

END
